/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.w3c.dom.Document;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static XmlSerializer createWriter(OutputStream out) throws IOException {
        assert (out != null);
        XmlSerializer writer = Xml.newSerializer();
        writer.setOutput(out, "UTF-8");
        return writer;
    }

    public static void startXmlDocument(XmlSerializer writer) throws IOException {
        assert (writer != null);
        writer.setPrefix("atom", "http://www.w3.org/2005/Atom");
        writer.setPrefix("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.setPrefix("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        writer.setPrefix("chemistry", "http://chemistry.apache.org/");
        writer.startDocument("UTF-8", Boolean.valueOf(false));
    }

    public static void endXmlDocument(XmlSerializer writer) throws IOException {
        assert (writer != null);
        writer.endDocument();
        writer.flush();
        writer.toString();
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, String value) throws IOException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        if (namespace == null) {
            writer.startTag(null, tag);
        } else {
            writer.startTag(namespace, tag);
        }
        writer.text(value);
        writer.endTag(namespace, tag);
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, BigInteger value) throws IOException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toString());
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, BigDecimal value) throws IOException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toString());
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, GregorianCalendar value) throws IOException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, DateTimeHelper.formatXmlDateTime(value));
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, Boolean value) throws IOException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value != false ? "true" : "false");
    }

    public static void write(XmlSerializer writer, String prefix, String namespace, String tag, Enum<?> value) throws IOException {
        Object enumValue;
        assert (writer != null);
        if (value == null) {
            return;
        }
        try {
            enumValue = value.getClass().getMethod("value", new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get enum value", e);
        }
        XMLUtils.write(writer, prefix, namespace, tag, enumValue.toString());
    }

    public static XmlPullParser createParser(InputStream stream) throws XmlPullParserException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(stream, "UTF-8");
        return parser;
    }

    public static boolean next(XmlPullParser parser) {
        assert (parser != null);
        try {
            if (XMLUtils.hasNext(parser)) {
                parser.next();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasNext(XmlPullParser parser) throws XmlPullParserException {
        assert (parser != null);
        return parser.getEventType() != 1;
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException {
        assert (parser != null);
        int level = 1;
        while (XMLUtils.next(parser)) {
            int event = parser.getEventType();
            if (event == 2) {
                ++level;
                continue;
            }
            if (event != 3 || --level != 0) continue;
            break;
        }
        XMLUtils.next(parser);
    }

    public static boolean findNextStartElemenet(XmlPullParser parser) throws XmlPullParserException, IOException {
        assert (parser != null);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                return true;
            }
            if (!XMLUtils.hasNext(parser)) break;
            parser.next();
        }
        return false;
    }

    public static String readText(XmlPullParser parser, int maxLength) throws XmlPullParserException {
        int event;
        assert (parser != null);
        assert (maxLength >= 0);
        StringBuilder sb = new StringBuilder(128);
        XMLUtils.next(parser);
        while ((event = parser.getEventType()) != 3) {
            if (event == 4) {
                int len = 0;
                if (parser.getText() != null) {
                    len = parser.getText().length();
                }
                if (len > 0) {
                    if (sb.length() + len > maxLength) {
                        throw new CmisInvalidArgumentException("String limit exceeded!");
                    }
                    sb.append(parser.getText());
                }
            } else if (event == 2) {
                throw new XmlPullParserException("Unexpected tag: " + parser.getName());
            }
            if (XMLUtils.next(parser)) continue;
            break;
        }
        XMLUtils.next(parser);
        return sb.toString();
    }

    public static Document newDomDocument() {
        throw new CmisRuntimeException("This method should never be used on Android!");
    }
}

