/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.CmisEnumHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLConstraints;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XMLWalker<T> {
    public T walk(XmlPullParser parser) throws XmlPullParserException {
        T result = this.prepareTarget(parser, new QName(parser.getNamespace(), parser.getName()));
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName name = new QName(parser.getNamespace(), parser.getName());
                if (this.read(parser, name, result)) continue;
                if (result instanceof ExtensionsData) {
                    this.handleExtension(parser, (ExtensionsData)result);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return result;
    }

    protected boolean isCmisNamespace(QName name) {
        return "http://docs.oasis-open.org/ns/cmis/core/200908/".hashCode() == name.getNamespaceURI().hashCode() && "http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI());
    }

    protected boolean isAtomNamespace(QName name) {
        return "http://www.w3.org/2005/Atom".hashCode() == name.getNamespaceURI().hashCode() && "http://www.w3.org/2005/Atom".equals(name.getNamespaceURI());
    }

    protected boolean isTag(QName name, String tag) {
        return tag.hashCode() == name.getLocalPart().hashCode() && tag.equals(name.getLocalPart());
    }

    protected void handleExtension(XmlPullParser parser, ExtensionsData extData) throws XmlPullParserException {
        List<CmisExtensionElement> extensions = extData.getExtensions();
        if (extensions == null) {
            extensions = new ArrayList<CmisExtensionElement>();
            extData.setExtensions(extensions);
        }
        if (extensions.size() + 1 > XMLConstraints.MAX_EXTENSIONS_WIDTH) {
            throw new CmisInvalidArgumentException("Too many extensions!");
        }
        extensions.add(this.handleExtensionLevel(parser, 0));
    }

    private CmisExtensionElement handleExtensionLevel(XmlPullParser parser, int level) throws XmlPullParserException {
        int event;
        QName name = new QName(parser.getNamespace(), parser.getName());
        HashMap<String, String> attributes = null;
        StringBuilder sb = new StringBuilder(128);
        ArrayList<CmisExtensionElement> children = null;
        if (parser.getAttributeCount() > 0) {
            attributes = new HashMap<String, String>();
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                attributes.put(parser.getAttributeName(i), parser.getAttributeValue(i));
            }
        }
        XMLUtils.next(parser);
        while ((event = parser.getEventType()) != 3) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    if (sb.length() + s.length() > 102400) {
                        throw new CmisInvalidArgumentException("String limit exceeded!");
                    }
                    sb.append(s);
                }
            } else if (event == 2) {
                if (level + 1 > XMLConstraints.MAX_EXTENSIONS_DEPTH) {
                    throw new CmisInvalidArgumentException("Extensions tree too deep!");
                }
                if (children == null) {
                    children = new ArrayList<CmisExtensionElement>();
                }
                if (children.size() + 1 > XMLConstraints.MAX_EXTENSIONS_WIDTH) {
                    throw new CmisInvalidArgumentException("Extensions tree too wide!");
                }
                children.add(this.handleExtensionLevel(parser, level + 1));
                continue;
            }
            if (XMLUtils.next(parser)) continue;
            break;
        }
        XMLUtils.next(parser);
        if (children != null) {
            return new CmisExtensionElementImpl(name.getNamespaceURI(), name.getLocalPart(), attributes, children);
        }
        return new CmisExtensionElementImpl(name.getNamespaceURI(), name.getLocalPart(), attributes, sb.toString());
    }

    protected <S> List<S> addToList(List<S> list, S value) {
        if (list == null || list.isEmpty()) {
            list = new ArrayList<S>();
        }
        list.add(value);
        return list;
    }

    protected String readText(XmlPullParser parser) throws XmlPullParserException {
        return XMLUtils.readText(parser, 102400);
    }

    protected Boolean readBoolean(XmlPullParser parser) throws XmlPullParserException {
        String value = this.readText(parser);
        if ("true".equals(value) || "1".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value) || "0".equals(value)) {
            return Boolean.FALSE;
        }
        throw new CmisInvalidArgumentException("Invalid boolean value!");
    }

    protected BigInteger readInteger(XmlPullParser parser) throws XmlPullParserException {
        String value = this.readText(parser);
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new CmisInvalidArgumentException("Invalid integer value!", e);
        }
    }

    protected BigDecimal readDecimal(XmlPullParser parser) throws XmlPullParserException {
        String value = this.readText(parser);
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new CmisInvalidArgumentException("Invalid decimal value!", e);
        }
    }

    protected GregorianCalendar readDateTime(XmlPullParser parser) throws XmlPullParserException {
        String value = this.readText(parser);
        GregorianCalendar result = DateTimeHelper.parseXmlDateTime(value);
        if (result == null) {
            throw new CmisInvalidArgumentException("Invalid datetime value!");
        }
        return result;
    }

    public <E extends Enum<E>> E readEnum(XmlPullParser parser, Class<E> clazz) throws XmlPullParserException {
        return CmisEnumHelper.fromValue(this.readText(parser), clazz);
    }

    protected abstract T prepareTarget(XmlPullParser var1, QName var2) throws XmlPullParserException;

    protected abstract boolean read(XmlPullParser var1, QName var2, T var3) throws XmlPullParserException;
}

