/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.beans.metadata.api.annotations.ExternalInstall;
import org.jboss.beans.metadata.api.annotations.Value;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.annotations.ClassAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueUtil;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalInstallationAnnotationPlugin<C extends Annotation>
extends ClassAnnotationPlugin<C> {
    protected ExternalInstallationAnnotationPlugin(Class<C> annotation) {
        super(annotation);
    }

    protected abstract List<InstallMetaData> getExistingInstallMetaData(BeanMetaData var1);

    protected abstract ExternalInstall[] getExternalInstalls(C var1);

    protected List<InstallMetaData> getInstallMetaData(C annotation) {
        ArrayList<InstallMetaData> installs = new ArrayList<InstallMetaData>();
        for (ExternalInstall install : this.getExternalInstalls(annotation)) {
            installs.add(this.createInstallMetaData(install));
        }
        return installs;
    }

    protected InstallMetaData createInstallMetaData(ExternalInstall install) {
        AbstractInstallMetaData installMetaData = new AbstractInstallMetaData();
        installMetaData.setBean(install.bean());
        installMetaData.setMethodName(install.method());
        if (ExternalInstallationAnnotationPlugin.isAttributePresent(install.dependantState())) {
            installMetaData.setDependentState(new ControllerState(install.dependantState()));
        }
        for (Value value : install.parameters()) {
            List<ParameterMetaData> parameters = installMetaData.getParameters();
            if (parameters == null) {
                parameters = new ArrayList<ParameterMetaData>();
                installMetaData.setParameters(parameters);
            }
            AbstractParameterMetaData parameter = new AbstractParameterMetaData(ValueUtil.createValueMetaData(value));
            if (ExternalInstallationAnnotationPlugin.isAttributePresent(value.type())) {
                parameter.setType(value.type());
            }
            parameters.add(parameter);
        }
        return installMetaData;
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, C annotation, KernelControllerContext context) throws Throwable {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        List<InstallMetaData> existing = this.getExistingInstallMetaData(beanMetaData);
        if (existing == null) {
            throw new IllegalArgumentException("Must set empty Set to installs/uninstalls!");
        }
        List<InstallMetaData> installs = this.getInstallMetaData(annotation);
        if (installs != null && !installs.isEmpty()) {
            ArrayList<InstallMetaData> nodes = new ArrayList<InstallMetaData>();
            for (InstallMetaData install : installs) {
                boolean doAdd = true;
                for (InstallMetaData existingInstall : existing) {
                    if (ExternalInstallationAnnotationPlugin.isDifferent(install, existingInstall)) continue;
                    doAdd = false;
                    break;
                }
                if (!doAdd) continue;
                existing.add(install);
                nodes.add(install);
            }
            return nodes;
        }
        return null;
    }

    protected static boolean isDifferent(InstallMetaData first, InstallMetaData second) {
        int sndSize;
        if (ExternalInstallationAnnotationPlugin.notEqual((Object)first.getBean(), (Object)second.getBean())) {
            return true;
        }
        if (ExternalInstallationAnnotationPlugin.notEqual((Object)first.getMethodName(), (Object)second.getMethodName())) {
            return true;
        }
        List<ParameterMetaData> fstParameters = first.getParameters();
        List<ParameterMetaData> sndParameters = second.getParameters();
        int fstSize = fstParameters != null ? fstParameters.size() : 0;
        int n = sndSize = sndParameters != null ? sndParameters.size() : 0;
        if (fstSize != sndSize) {
            return true;
        }
        for (int i = 0; i < fstSize; ++i) {
            Object sndObject;
            Class<?> sndClass;
            ParameterMetaData fstParameter = fstParameters.get(i);
            ParameterMetaData sndParameter = sndParameters.get(i);
            if (ExternalInstallationAnnotationPlugin.notEqual((Object)fstParameter.getType(), (Object)sndParameter.getType())) {
                return true;
            }
            ValueMetaData fstValue = fstParameter.getValue();
            ValueMetaData sndValue = sndParameter.getValue();
            Class<?> fstClass = fstValue != null ? fstValue.getClass() : null;
            Class<?> clazz = sndClass = sndValue != null ? sndValue.getClass() : null;
            if (ExternalInstallationAnnotationPlugin.notEqual(fstClass, sndClass)) {
                return true;
            }
            Object fstObject = fstValue != null ? fstValue.getUnderlyingValue() : null;
            Object object = sndObject = sndValue != null ? sndValue.getUnderlyingValue() : null;
            if (fstObject == null || sndObject == null || !ExternalInstallationAnnotationPlugin.notEqual((Object)fstObject, (Object)sndObject)) continue;
            return true;
        }
        return false;
    }
}

