/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.config.property;

import java.util.Properties;
import java.util.TreeSet;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.kernel.plugins.bootstrap.basic.KernelConstants;
import org.jboss.kernel.plugins.config.AbstractKernelConfig;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.bootstrap.KernelInitializer;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;

public class PropertyKernelConfig
extends AbstractKernelConfig {
    public PropertyKernelConfig(Properties properties) {
        super((Configuration)new PropertyConfiguration(properties));
        this.initializeProperties();
    }

    protected Properties getProperties() {
        PropertyConfiguration config = (PropertyConfiguration)this.configuration;
        return config.getProperties();
    }

    protected void initializeProperties() {
        Properties properties = this.getProperties();
        if (!properties.isEmpty() && this.log.isTraceEnabled()) {
            this.log.trace((Object)"Dumping properties");
            TreeSet<Object> names = new TreeSet<Object>(properties.keySet());
            for (String string : names) {
                this.log.trace((Object)(string + "=" + properties.get(string)));
            }
        }
    }

    public KernelBus createKernelBus() throws Throwable {
        return (KernelBus)this.getImplementation(KernelConstants.KERNEL_BUS_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelBus");
    }

    public KernelConfigurator createKernelConfigurator() throws Throwable {
        return (KernelConfigurator)this.getImplementation(KernelConstants.KERNEL_CONFIGURATOR_PROPERTY, "org.jboss.kernel.plugins.config.AbstractKernelConfigurator");
    }

    public KernelController createKernelController() throws Throwable {
        return (KernelController)this.getImplementation(KernelConstants.KERNEL_CONTROLLER_PROPERTY, "org.jboss.kernel.plugins.dependency.AbstractKernelController");
    }

    public KernelEventManager createKernelEventManager() throws Throwable {
        return (KernelEventManager)this.getImplementation(KernelConstants.KERNEL_EVENT_MANAGER_PROPERTY, "org.jboss.kernel.plugins.event.AbstractEventManager");
    }

    public KernelInitializer createKernelInitializer() throws Throwable {
        return (KernelInitializer)this.getImplementation(KernelConstants.KERNEL_INITIALIZER_PROPERTY, "org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer");
    }

    public KernelRegistry createKernelRegistry() throws Throwable {
        return (KernelRegistry)this.getImplementation(KernelConstants.KERNEL_REGISTRY_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelRegistry");
    }

    public KernelMetaDataRepository createKernelMetaDataRepository() throws Throwable {
        return (KernelMetaDataRepository)this.getImplementation(KernelConstants.KERNEL_METADATA_REPOSITORY_PROPERTY, "org.jboss.kernel.plugins.metadata.basic.BasicKernelMetaDataRepository");
    }

    protected Object getImplementation(String type, String defaultType) throws Throwable {
        Properties properties = this.getProperties();
        String className = properties.getProperty(type, defaultType);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(type + " using implementation " + className));
        }
        ClassLoader cl = Configurator.getClassLoader((BeanMetaData)null);
        BeanInfo info = this.getBeanInfo(className, cl);
        BeanMetaData metaData = this.getBeanMetaData(info, className);
        return Configurator.instantiateAndConfigure(this, info, metaData);
    }

    protected BeanMetaData getBeanMetaData(BeanInfo info, String className) throws Exception {
        return null;
    }
}

