/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import com.sun.facelets.Facelet;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.faces.Renderer;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.ui.facelet.FaceletCompiler;
import org.jboss.seam.ui.util.JSF;

@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Name(value="org.jboss.seam.faces.renderer")
@AutoCreate
@Install(value=true, precedence=0, classDependencies={"com.sun.facelets.Facelet"})
public class FaceletsRenderer
extends Renderer {
    public String render(final String viewId) {
        RenderingContext context = new RenderingContext(viewId){

            public void process() {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                try {
                    FaceletsRenderer.this.renderFacelet(facesContext, FaceletsRenderer.this.faceletForURL(FaceletsRenderer.this.resourceURL(viewId)));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error rendering view", e);
                }
            }
        };
        context.run();
        return context.getOutput();
    }

    protected URL resourceURL(String viewId) {
        URL url = ResourceLoader.instance().getResource(viewId);
        if (url == null) {
            throw new IllegalArgumentException("resource doesn't exist: " + viewId);
        }
        return url;
    }

    protected Facelet faceletForURL(URL url) throws IOException {
        return new DefaultFaceletFactory(FaceletCompiler.instance(), (ResourceResolver)new DefaultResourceResolver()).getFacelet(url);
    }

    protected void renderFacelet(FacesContext facesContext, Facelet facelet) throws IOException {
        UIViewRoot root = facesContext.getViewRoot();
        facelet.apply(facesContext, (UIComponent)root);
        JSF.renderChildren(facesContext, (UIComponent)root);
    }

    protected abstract class RenderingContext {
        private String viewId;
        private ClassLoader originalClassLoader;
        private ResponseWriter originalResponseWriter;
        private UIViewRoot originalViewRoot;
        private StringWriter writer = new StringWriter();

        public RenderingContext(String viewId) {
            this.viewId = viewId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.init();
                this.process();
            }
            finally {
                this.cleanup();
            }
        }

        private void init() {
            this.originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (FacesContext.getCurrentInstance() == null) {
                MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext()).setCurrent();
                mockFacesContext.createViewRoot();
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.originalResponseWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter(facesContext.getRenderKit().createResponseWriter((Writer)this.writer, null, null));
            this.originalViewRoot = facesContext.getViewRoot();
            UIViewRoot viewRoot = new UIViewRoot();
            viewRoot.setRenderKitId(facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext));
            viewRoot.setViewId(this.viewId);
            viewRoot.setLocale(this.originalViewRoot.getLocale());
            facesContext.setViewRoot(viewRoot);
        }

        private void cleanup() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (this.originalResponseWriter != null) {
                facesContext.setResponseWriter(this.originalResponseWriter);
            }
            if (this.originalViewRoot != null) {
                facesContext.setViewRoot(this.originalViewRoot);
            }
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }

        public String getOutput() {
            return this.writer.getBuffer().toString();
        }

        protected abstract void process();
    }
}

