/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.ui.resource.SafeStyleResources;
import org.jboss.seam.util.Resources;
import org.jboss.seam.web.AbstractResource;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.ui.resource.styleResource")
@Install(precedence=0)
@BypassInterceptors
public class StyleResource
extends AbstractResource {
    private LogProvider log = Logging.getLogProvider(StyleResource.class);
    private static final Pattern EL_PATTERN = Pattern.compile("#" + Pattern.quote("{") + "(.*)" + Pattern.quote("}"));
    private static final Pattern ID_PATTERN = Pattern.compile("#([A-Za-z][A-Za-z0-9\\-\\_\\:\\.]*)");
    public static final String WEB_RESOURCE_PATH = "/seam/resource/style";
    private static final String RESOURCE_PATH = "/style";

    public void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        new ContextualHttpServletRequest(request){

            public void process() throws IOException {
                StyleResource.this.doWork(request, response);
            }
        }.run();
    }

    public void doWork(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo().substring(this.getResourcePath().length());
        if (!SafeStyleResources.instance().isStyleResourceSafe(pathInfo)) {
            this.log.warn((Object)(pathInfo + " isn't recognized as a valid stylesheet"));
            response.sendError(404);
            return;
        }
        InputStream in = Resources.getResourceAsStream((String)pathInfo, (ServletContext)this.getServletContext());
        if (in != null) {
            CharSequence css = this.readFile(in);
            css = this.parseEL(css);
            String idPrefix = request.getParameter("idPrefix");
            css = this.addIdPrefix(idPrefix, css);
            response.getWriter().write(((Object)css).toString());
            response.getWriter().flush();
        } else {
            response.sendError(404);
        }
    }

    private CharSequence parseEL(CharSequence string) {
        StringBuffer parsed = new StringBuffer(string.length());
        Matcher matcher = EL_PATTERN.matcher(string);
        while (matcher.find()) {
            String result = (String)Expressions.instance().createValueExpression("#{" + matcher.group(1) + "}", String.class).getValue();
            if (result != null) {
                matcher.appendReplacement(parsed, result);
                continue;
            }
            matcher.appendReplacement(parsed, "");
        }
        matcher.appendTail(parsed);
        return parsed;
    }

    private CharSequence readFile(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder css = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            css.append(line);
            css.append("\n");
        }
        inputStream.close();
        return css;
    }

    private CharSequence addIdPrefix(String idPrefix, CharSequence string) {
        StringBuffer parsed = new StringBuffer(string.length());
        if (idPrefix != null) {
            Matcher matcher = ID_PATTERN.matcher(string);
            while (matcher.find()) {
                String result = "#" + idPrefix + ":" + matcher.group(1);
                matcher.appendReplacement(parsed, result);
            }
            matcher.appendTail(parsed);
            return parsed;
        }
        return string;
    }

    public String getResourcePath() {
        return RESOURCE_PATH;
    }
}

