/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Version;
import org.jboss.seam.Model;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
extends Model {
    private Method preRemoveMethod;
    private Method prePersistMethod;
    private Method preUpdateMethod;
    private Method postLoadMethod;
    private Method identifierGetter;
    private Field identifierField;
    private Method versionGetter;
    private Field versionField;
    private String name;

    public Entity(Class<?> beanClass) {
        super(beanClass);
        if (beanClass.isAnnotationPresent(javax.persistence.Entity.class)) {
            this.name = !"".equals(beanClass.getAnnotation(javax.persistence.Entity.class).name()) ? beanClass.getAnnotation(javax.persistence.Entity.class).name() : beanClass.getName();
        }
        for (Class<?> clazz = beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(PreRemove.class)) {
                    this.preRemoveMethod = method;
                }
                if (method.isAnnotationPresent(PrePersist.class)) {
                    this.prePersistMethod = method;
                }
                if (method.isAnnotationPresent(PreUpdate.class)) {
                    this.preUpdateMethod = method;
                }
                if (method.isAnnotationPresent(PostLoad.class)) {
                    this.postLoadMethod = method;
                }
                if (method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class)) {
                    this.identifierGetter = method;
                }
                if (method.isAnnotationPresent(Version.class)) {
                    this.versionGetter = method;
                }
                if (method.isAccessible()) continue;
                method.setAccessible(true);
            }
            if (this.identifierGetter != null) continue;
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (accessibleObject.isAnnotationPresent(Id.class) || accessibleObject.isAnnotationPresent(EmbeddedId.class)) {
                    this.identifierField = accessibleObject;
                    if (!accessibleObject.isAccessible()) {
                        ((Field)accessibleObject).setAccessible(true);
                    }
                }
                if (!accessibleObject.isAnnotationPresent(Version.class)) continue;
                this.versionField = accessibleObject;
                if (accessibleObject.isAccessible()) continue;
                ((Field)accessibleObject).setAccessible(true);
            }
        }
    }

    public Method getPostLoadMethod() {
        return this.postLoadMethod;
    }

    public Method getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public Method getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public Method getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    public Field getIdentifierField() {
        return this.identifierField;
    }

    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    public Field getVersionField() {
        return this.versionField;
    }

    public Method getVersionGetter() {
        return this.versionGetter;
    }

    public Object getIdentifier(Object entity) {
        if (this.identifierGetter != null) {
            return Reflections.invokeAndWrap(this.identifierGetter, entity, new Object[0]);
        }
        if (this.identifierField != null) {
            return Reflections.getAndWrap(this.identifierField, entity);
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.getBeanClass().getName());
    }

    public Object getVersion(Object entity) {
        if (this.versionGetter != null) {
            return Reflections.invokeAndWrap(this.versionGetter, entity, new Object[0]);
        }
        if (this.versionField != null) {
            return Reflections.getAndWrap(this.versionField, entity);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static Entity forClass(Class clazz) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        Class entityClass = Seam.getEntityClass(clazz);
        if (entityClass == null) {
            throw new IllegalArgumentException("Not an entity class: " + clazz.getName());
        }
        String name = Entity.getModelName(entityClass);
        Model model = (Model)Contexts.getApplicationContext().get(name);
        if (model == null || !(model instanceof Entity)) {
            Entity entity = new Entity(entityClass);
            Contexts.getApplicationContext().set(name, entity);
            return entity;
        }
        return (Entity)model;
    }
}

