/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NthBusinessDay
implements Serializable {
    int n;
    String fireAtTime;
    List<Date> additionalHolidays;
    BusinessDayIntervalType interval;
    boolean excludeWeekends;
    boolean excludeUsFederalHolidays;

    public NthBusinessDay() {
        this.n = 1;
        this.fireAtTime = "12:00";
        this.additionalHolidays = new ArrayList<Date>();
        this.interval = BusinessDayIntervalType.WEEKLY;
        this.excludeWeekends = true;
        this.excludeUsFederalHolidays = true;
    }

    public NthBusinessDay(int n, String fireAtTime, BusinessDayIntervalType interval) {
        this.n = n;
        this.fireAtTime = fireAtTime;
        this.additionalHolidays = new ArrayList<Date>();
        this.interval = interval;
        this.excludeWeekends = true;
        this.excludeUsFederalHolidays = true;
    }

    public NthBusinessDay(int n, String fireAtTime, List<Date> additionalHolidays, BusinessDayIntervalType interval, boolean excludeWeekends, boolean excludeUsFederalHolidays) {
        this.n = n;
        this.fireAtTime = fireAtTime;
        this.additionalHolidays = additionalHolidays;
        this.interval = interval;
        this.excludeWeekends = excludeWeekends;
        this.excludeUsFederalHolidays = excludeUsFederalHolidays;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public String getFireAtTime() {
        return this.fireAtTime;
    }

    public void setFireAtTime(String fireAtTime) {
        this.fireAtTime = fireAtTime;
    }

    public List<Date> getAdditionalHolidays() {
        return this.additionalHolidays;
    }

    public void setAdditionalHolidays(List<Date> additionalHolidays) {
        this.additionalHolidays = additionalHolidays;
    }

    public BusinessDayIntervalType getInterval() {
        return this.interval;
    }

    public void setInterval(BusinessDayIntervalType interval) {
        this.interval = interval;
    }

    public boolean getExcludeWeekends() {
        return this.excludeWeekends;
    }

    public void setExcludeWeekends(boolean excludeWeekends) {
        this.excludeWeekends = excludeWeekends;
    }

    public boolean getExcludeUsFederalHolidays() {
        return this.excludeUsFederalHolidays;
    }

    public void setExcludeUsFederalHolidays(boolean excludeUsFederalHolidays) {
        this.excludeUsFederalHolidays = excludeUsFederalHolidays;
    }

    public HolidayCalendar getHolidayCalendar() {
        HolidayCalendar holidays;
        if (this.excludeWeekends) {
            WeeklyCalendar wCal = new WeeklyCalendar();
            holidays = new HolidayCalendar((org.quartz.Calendar)wCal);
        } else {
            holidays = new HolidayCalendar();
        }
        for (Date d : this.additionalHolidays) {
            holidays.addExcludedDate(d);
        }
        if (this.excludeUsFederalHolidays) {
            Calendar hCal = Calendar.getInstance();
            hCal.set(2007, 0, 1);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 0, 15);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 1, 19);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 4, 28);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 6, 4);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 8, 3);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 9, 8);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 10, 12);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 10, 22);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2007, 11, 25);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 0, 1);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 0, 21);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 1, 18);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 4, 26);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 6, 4);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 8, 1);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 9, 13);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 10, 11);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 10, 27);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2008, 11, 25);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 0, 1);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 0, 19);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 1, 16);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 4, 25);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 6, 3);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 8, 7);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 9, 12);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 10, 11);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 10, 26);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2009, 11, 25);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 0, 1);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 0, 18);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 1, 15);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 4, 31);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 6, 5);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 8, 6);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 9, 11);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 10, 11);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 10, 25);
            holidays.addExcludedDate(hCal.getTime());
            hCal.set(2010, 11, 24);
            holidays.addExcludedDate(hCal.getTime());
        }
        return holidays;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BusinessDayIntervalType {
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

