/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.deployment.ComponentScanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class GroovyComponentScanner
extends ComponentScanner {
    private static final LogProvider log = Logging.getLogProvider(GroovyComponentScanner.class);
    private final String groovyFileExtension;

    public GroovyComponentScanner(String resourceName, String groovyFileExtension) {
        super(resourceName);
        this.groovyFileExtension = groovyFileExtension;
    }

    public GroovyComponentScanner(String resourceName, GroovyClassLoader classLoader, String groovyFileExtension) {
        super(resourceName, (ClassLoader)classLoader);
        this.groovyFileExtension = groovyFileExtension;
    }

    protected URL[] getURLsFromClassLoader() {
        return ((URLClassLoader)this.classLoader.getParent()).getURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(String name) {
        super.handleItem(name);
        if (name.endsWith(this.groovyFileExtension)) {
            log.debug("Found a groovy file: " + name);
            String classname = this.filenameToGroovyname(name);
            String filename = this.groovyComponentFilename(name);
            BufferedReader buffReader = null;
            try {
                InputStream stream = this.classLoader.getResourceAsStream(name);
                buffReader = new BufferedReader(new InputStreamReader(stream));
                String line = buffReader.readLine();
                while (line != null) {
                    if (line.indexOf("@Name") != -1 || line.indexOf("@" + Name.class.getName()) != -1) {
                        boolean installable;
                        log.debug("Groovy file possibly a Seam component: " + name);
                        Class<?> groovyClass = this.classLoader.loadClass(classname);
                        Install install = groovyClass.getAnnotation(Install.class);
                        boolean bl = installable = !(install != null && !install.value() || !groovyClass.isAnnotationPresent(Name.class) && !this.classLoader.getResources(filename).hasMoreElements());
                        if (installable) {
                            log.debug("found groovy component class: " + name);
                            this.classes.add(groovyClass);
                        }
                        break;
                    }
                    line = buffReader.readLine();
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.debug("could not load groovy class: " + classname, cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug("could not load groovy class (missing dependency): " + classname, ncdfe);
            }
            catch (IOException ioe) {
                log.debug("could not load groovy file: " + classname, ioe);
            }
            catch (CompilationFailedException e) {
                log.info("Compilation error in Groovy file:" + classname, e);
            }
            catch (GroovyRuntimeException e) {
                log.info("Unknown error reading Groovy file:" + classname, e);
            }
            finally {
                if (buffReader != null) {
                    try {
                        buffReader.close();
                    }
                    catch (IOException e) {
                        log.trace("Could not close stream");
                    }
                }
            }
        }
    }

    public String filenameToGroovyname(String filename) {
        return filename.substring(0, filename.lastIndexOf(this.groovyFileExtension)).replace('/', '.').replace('\\', '.');
    }

    public String groovyComponentFilename(String name) {
        return name.substring(0, name.lastIndexOf(this.groovyFileExtension)) + ".component.xml";
    }
}

