/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.jboss.seam.security.EntityAction;
import org.jboss.seam.security.Identity;

public class EntitySecurityListener {
    @PostLoad
    public void postLoad(Object entity) {
        if (Identity.isSecurityEnabled()) {
            Identity.instance().checkEntityPermission(entity, EntityAction.READ);
        }
    }

    @PrePersist
    public void prePersist(Object entity) {
        if (Identity.isSecurityEnabled()) {
            Identity.instance().checkEntityPermission(entity, EntityAction.INSERT);
        }
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        if (Identity.isSecurityEnabled()) {
            Identity.instance().checkEntityPermission(entity, EntityAction.UPDATE);
        }
    }

    @PreRemove
    public void preRemove(Object entity) {
        if (Identity.isSecurityEnabled()) {
            Identity.instance().checkEntityPermission(entity, EntityAction.DELETE);
        }
    }
}

