/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.Selector;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Configuration;
import org.jboss.seam.security.EntityAction;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.util.Strings;
import org.jboss.seam.web.Session;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
@Startup
public class Identity
extends Selector {
    private static boolean securityEnabled = true;
    public static final String ROLES_GROUP = "Roles";
    private static final String LOGIN_TRIED = "org.jboss.seam.security.loginTried";
    private static final long serialVersionUID = 3751659008033189259L;
    private static final LogProvider log = Logging.getLogProvider(Identity.class);
    private String username;
    private String password;
    private Expressions.MethodExpression authenticateMethod;
    private Principal principal;
    private Subject subject;
    private String jaasConfigName = null;
    private List<String> preAuthenticationRoles = new ArrayList<String>();
    private boolean authenticateEveryRequest = false;
    private boolean authenticating = false;

    protected String getCookieName() {
        return "org.jboss.seam.security.username";
    }

    @Create
    public void create() {
        this.subject = new Subject();
        this.initCredentialsFromCookie();
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        securityEnabled = enabled;
    }

    public boolean getAuthenticateEveryRequest() {
        return this.authenticateEveryRequest;
    }

    public void setAuthenticateEveryRequest(boolean authenticateEveryRequest) {
        this.authenticateEveryRequest = authenticateEveryRequest;
    }

    protected void initCredentialsFromCookie() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            this.setCookiePath(ctx.getExternalContext().getRequestContextPath());
        }
        this.username = this.getCookieValue();
        if (this.username != null) {
            this.setCookieEnabled(true);
            this.postRememberMe();
        }
        this.setDirty();
    }

    public void beginRequest() {
    }

    public void endRequest() {
    }

    protected void postRememberMe() {
        Events.instance().raiseEvent("org.jboss.seam.rememberMe", new Object[0]);
    }

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION);
        if (instance == null) {
            throw new IllegalStateException("No Identity could be created");
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn(true);
    }

    public boolean isLoggedIn(boolean attemptLogin) {
        if (!this.authenticating && attemptLogin && this.getPrincipal() == null && this.isCredentialsSet() && Contexts.isEventContextActive() && !Contexts.getEventContext().isSet(LOGIN_TRIED)) {
            Contexts.getEventContext().set(LOGIN_TRIED, true);
            this.quietLogin();
        }
        return this.getPrincipal() != null;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isCredentialsSet() {
        return this.username != null && this.password != null;
    }

    public void checkRestriction(String expr) {
        if (!this.evaluateExpression(expr)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                log.debug(String.format("Error evaluating expression [%s] - User not logged in", expr));
                throw new NotLoggedInException();
            }
            Events.instance().raiseEvent("org.jboss.seam.notAuthorized", new Object[0]);
            throw new AuthorizationException(String.format("Authorization check failed for expression [%s]", expr));
        }
    }

    public String login() {
        try {
            this.authenticate();
            if (log.isDebugEnabled()) {
                log.debug("Login successful for: " + this.getUsername());
            }
            this.addLoginSuccessfulMessage();
            return "loggedIn";
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Login failed for: " + this.getUsername(), ex);
            }
            this.addLoginFailedMessage(ex);
            return null;
        }
    }

    public void quietLogin() {
        try {
            if (this.isCredentialsSet()) {
                this.authenticate();
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    protected void addLoginFailedMessage(LoginException ex) {
        FacesMessages.instance().addFromResourceBundleOrDefault(this.getLoginFailedMessageSeverity(), this.getLoginFailedMessageKey(), this.getLoginFailedMessage(), ex);
    }

    protected String getLoginFailedMessage() {
        return "Login failed";
    }

    protected FacesMessage.Severity getLoginFailedMessageSeverity() {
        return FacesMessage.SEVERITY_INFO;
    }

    protected String getLoginFailedMessageKey() {
        return "org.jboss.seam.loginFailed";
    }

    protected void addLoginSuccessfulMessage() {
        FacesMessages.instance().addFromResourceBundleOrDefault(this.getLoginSuccessfulMessageSeverity(), this.getLoginSuccessfulMessageKey(), this.getLoginSuccessfulMessage(), this.getUsername());
    }

    protected FacesMessage.Severity getLoginSuccessfulMessageSeverity() {
        return FacesMessage.SEVERITY_INFO;
    }

    protected String getLoginSuccessfulMessage() {
        return "Welcome, #0";
    }

    protected String getLoginSuccessfulMessageKey() {
        return "org.jboss.seam.loginSuccessful";
    }

    public void authenticate() throws LoginException {
        if (!this.isLoggedIn()) {
            this.authenticate(this.getLoginContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(LoginContext loginContext) throws LoginException {
        try {
            this.authenticating = true;
            this.preAuthenticate();
            loginContext.login();
            this.postAuthenticate();
        }
        finally {
            this.authenticating = false;
        }
    }

    protected void preAuthenticate() {
        this.unAuthenticate();
        this.preAuthenticationRoles.clear();
        Events.instance().raiseEvent("org.jboss.seam.preAuthenticate", new Object[0]);
    }

    protected void postAuthenticate() {
        for (Principal p : this.getSubject().getPrincipals()) {
            if (p instanceof Group || this.principal != null) continue;
            this.principal = p;
            this.setDirty();
            break;
        }
        if (!this.preAuthenticationRoles.isEmpty() && this.isLoggedIn()) {
            for (String role : this.preAuthenticationRoles) {
                this.addRole(role);
            }
            this.preAuthenticationRoles.clear();
        }
        if (!this.isRememberMe()) {
            this.clearCookieValue();
        }
        this.setCookieValueIfEnabled(this.getUsername());
        this.password = null;
        this.setDirty();
        Events.instance().raiseEvent("org.jboss.seam.postAuthenticate", new Object[0]);
    }

    protected void unAuthenticate() {
        this.principal = null;
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            this.getSubject().getPrincipals().remove(sg);
            break;
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.getJaasConfigName() != null) {
            return new LoginContext(this.getJaasConfigName(), this.getSubject(), this.getDefaultCallbackHandler());
        }
        return new LoginContext("default", this.getSubject(), this.getDefaultCallbackHandler(), Configuration.instance());
    }

    public void logout() {
        this.principal = null;
        Session.instance().invalidate();
        Events.instance().raiseEvent("org.jboss.seam.loggedOut", new Object[0]);
    }

    public boolean hasRole(String role) {
        this.isLoggedIn(true);
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.isMember((Principal)new SimplePrincipal(role));
        }
        return false;
    }

    public boolean addRole(String role) {
        if (!this.isLoggedIn()) {
            this.preAuthenticationRoles.add(role);
            return false;
        }
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.addMember((Principal)new SimplePrincipal(role));
        }
        SimpleGroup roleGroup = new SimpleGroup(ROLES_GROUP);
        roleGroup.addMember(new SimplePrincipal(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    public void removeRole(String role) {
        block0: for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            Enumeration e = sg.members();
            while (e.hasMoreElements()) {
                Principal member = (Principal)e.nextElement();
                if (!member.getName().equals(role)) continue;
                sg.removeMember(member);
                continue block0;
            }
        }
    }

    public void checkRole(String role) {
        this.isLoggedIn(true);
        if (!this.hasRole(role)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for role [%s]", role));
        }
    }

    public void checkPermission(String name, String action, Object ... arg) {
        this.isLoggedIn(true);
        if (!this.hasPermission(name, action, arg)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for permission [%s,%s]", name, action));
        }
    }

    public boolean hasPermission(String name, String action, Object ... arg) {
        return false;
    }

    protected CallbackHandler getDefaultCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(Identity.this.getUsername());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(Identity.this.getPassword() != null ? Identity.this.getPassword().toCharArray() : null);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unsupported callback");
                }
            }
        };
    }

    protected boolean evaluateExpression(String expr) {
        return Expressions.instance().createValueExpression(expr, Boolean.class).getValue();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.setDirty(this.username, username);
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.setDirty(this.password, password);
        this.password = password;
    }

    public Expressions.MethodExpression getAuthenticateMethod() {
        return this.authenticateMethod;
    }

    public void setAuthenticateMethod(Expressions.MethodExpression authMethod) {
        this.authenticateMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.isCookieEnabled();
    }

    public void setRememberMe(boolean remember) {
        this.setCookieEnabled(remember);
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    public void checkEntityPermission(Object entity, EntityAction action) {
        this.isLoggedIn(true);
        PersistenceProvider provider = PersistenceProvider.instance();
        Class beanClass = provider.getBeanClass(entity);
        if (beanClass != null) {
            String name = Seam.getComponentName(entity.getClass());
            if (name == null) {
                name = beanClass.getName();
            }
            Method m = null;
            switch (action) {
                case READ: {
                    m = provider.getPostLoadMethod(beanClass);
                    break;
                }
                case INSERT: {
                    m = provider.getPrePersistMethod(beanClass);
                    break;
                }
                case UPDATE: {
                    m = provider.getPreUpdateMethod(beanClass);
                    break;
                }
                case DELETE: {
                    m = provider.getPreRemoveMethod(beanClass);
                }
            }
            Restrict restrict = null;
            if (m != null && m.isAnnotationPresent(Restrict.class)) {
                restrict = m.getAnnotation(Restrict.class);
            } else if (entity.getClass().isAnnotationPresent(Restrict.class)) {
                restrict = entity.getClass().getAnnotation(Restrict.class);
            }
            if (restrict != null) {
                if (Strings.isEmpty(restrict.value())) {
                    this.checkPermission(name, action.toString(), entity);
                } else {
                    this.checkRestriction(restrict.value());
                }
            }
        }
    }
}

