/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jboss.seam.deployment.GroovyDeploymentHandler;
import org.jboss.seam.deployment.HotDeploymentStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyHotDeploymentStrategy
extends HotDeploymentStrategy {
    private static final String DEFAULT_SCRIPT_EXTENSION = new CompilerConfiguration().getDefaultScriptExtension();
    private ClassLoader classLoader;
    private GroovyDeploymentHandler groovyDeploymentHandler;

    public GroovyHotDeploymentStrategy(ClassLoader classLoader, File hotDeployDirectory) {
        super(classLoader, hotDeployDirectory);
        if (super.getClassLoader() != null) {
            this.classLoader = new GroovyClassLoader(super.getClassLoader());
        }
        this.groovyDeploymentHandler = new GroovyDeploymentHandler(DEFAULT_SCRIPT_EXTENSION);
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.GroovyDeploymentHandler", this.groovyDeploymentHandler);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isFromHotDeployClassLoader(Class componentClass) {
        if (this.getClassLoader() == null) {
            return false;
        }
        ClassLoader classClassLoader = componentClass.getClassLoader().getParent();
        return classClassLoader == this.getClassLoader() || classClassLoader == this.getClassLoader().getParent();
    }

    @Override
    public Set<Class<Object>> getScannedComponentClasses() {
        HashSet<Class<Object>> set = new HashSet<Class<Object>>();
        set.addAll(super.getScannedComponentClasses());
        set.addAll(this.groovyDeploymentHandler.getClasses());
        return Collections.unmodifiableSet(set);
    }
}

