/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.drools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.drools.RuleBase;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class RuleAgent {
    private static final LogProvider log = Logging.getLogProvider(RuleAgent.class);
    private org.drools.agent.RuleAgent agent;
    private String configurationFile;
    private String newInstance;
    private String files;
    private String url;
    private String localCacheDir;
    private String poll;
    private String configName;

    @Create
    public void createAgent() throws Exception {
        Properties properties = new Properties();
        this.loadFromPath(properties, this.configurationFile);
        this.setLocalProperties(properties);
        this.agent = org.drools.agent.RuleAgent.newRuleAgent((Properties)properties);
        log.debug("Creating new rules agent");
    }

    protected void setLocalProperties(Properties properties) {
        if (this.newInstance != null) {
            properties.setProperty("newInstance", this.newInstance);
        }
        if (this.files != null) {
            properties.setProperty("file", this.files);
        }
        if (this.url != null) {
            properties.setProperty("url", this.url);
        }
        if (this.localCacheDir != null) {
            properties.setProperty("localCacheDir", this.localCacheDir);
        }
        if (this.poll != null) {
            properties.setProperty("poll", this.poll);
        }
        if (this.files != null) {
            properties.setProperty("name", this.configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromPath(Properties properties, String configurationFile) throws IOException {
        InputStream inputStream;
        if (configurationFile != null && (inputStream = Resources.getResourceAsStream(configurationFile, null)) != null) {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
    }

    @Unwrap
    public RuleBase getRuleBase() {
        return this.agent.getRuleBase();
    }

    public String getNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(String newInstance) {
        this.newInstance = newInstance;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLocalCacheDir() {
        return this.localCacheDir;
    }

    public void setLocalCacheDir(String localCacheDir) {
        this.localCacheDir = localCacheDir;
    }

    public String getPoll() {
        return this.poll;
    }

    public void setPoll(String poll) {
        this.poll = poll;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String name) {
        this.configName = name;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String brmsConfig) {
        this.configurationFile = brmsConfig;
    }
}

