/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.deployment.ComponentDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotDeploymentStrategy
extends DeploymentStrategy {
    public static final String DEFAULT_HOT_DEPLOYMENT_DIRECTORY_PATH = "WEB-INF/dev";
    public static final String NAME = "org.jboss.seam.deployment.hotDeploymentStrategy";
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.hotDeploymentHandlers";
    private ClassLoader hotDeployClassLoader;
    private File[] hotDeploymentPaths;
    private ComponentDeploymentHandler componentDeploymentHandler;

    public HotDeploymentStrategy(ClassLoader classLoader, File hotDeployDirectory) {
        this.initHotDeployClassLoader(classLoader, hotDeployDirectory);
        this.componentDeploymentHandler = new ComponentDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.ComponentDeploymentHandler", this.componentDeploymentHandler);
    }

    private void initHotDeployClassLoader(ClassLoader classLoader, File hotDeployDirectory) {
        try {
            if (hotDeployDirectory.exists()) {
                URL url = hotDeployDirectory.toURL();
                URL[] urls = new URL[]{url};
                this.hotDeployClassLoader = new URLClassLoader(urls, classLoader);
                this.hotDeploymentPaths = new File[]{hotDeployDirectory};
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    @Override
    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    public File[] getHotDeploymentPaths() {
        return this.hotDeploymentPaths;
    }

    public boolean isFromHotDeployClassLoader(Class componentClass) {
        return componentClass.getClassLoader() == this.hotDeployClassLoader;
    }

    public static HotDeploymentStrategy createInstance(String className, ClassLoader classLoader, File hotDeployDirectory) {
        try {
            Class initializer = Reflections.classForName(className);
            Constructor ctr = initializer.getConstructor(ClassLoader.class, File.class);
            return (HotDeploymentStrategy)ctr.newInstance(classLoader, hotDeployDirectory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such deployment strategy " + className, e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.hotDeployClassLoader;
    }

    public Set<Class<Object>> getScannedComponentClasses() {
        return this.componentDeploymentHandler.getClasses();
    }

    @Override
    public void scan() {
        this.getScanner().scanDirectories(this.getHotDeploymentPaths());
    }

    public static HotDeploymentStrategy instance() {
        if (Contexts.getEventContext().isSet(NAME)) {
            return (HotDeploymentStrategy)Contexts.getEventContext().get(NAME);
        }
        return null;
    }
}

